% Run mooring scenarios and plot profiles

% Mean speed

MakWest;
velocity = [ 0      0.40;
            -200    0.39;
		    -250	0.43;
		    -350	0.32;
		    -750	0.14;
		    -1500   0.13;
            -2200   0.10];

% Files

checkFile = 'MakWestMean';
mooringFile = 'MakWest';

runmoor;
depthMean = depth;
hdistMean = hdist;
nodesMean = fnodes;

% Plot mooring

plmoor4

% Max speed profile

MakWest;
velocity = [ 0      0.75;
            -200    0.90;
            -250    0.85;
            -350    0.80;
            -750    0.82;
            -1500   0.63;
            -2200   0.10];

% Print file

checkFile = 'MakWestMax';

runmoor;
depthMax = depth;
hdistMax = hdist;
nodesMax = fnodes;

% Plot

figure(4);
clf
plot(hdistMean, -1. * depthMean, '-', 'linewidth', 1);
hold on
plot(hdistMax, -1. * depthMax, '-', 'linewidth', 1);
axis equal
set(gca, 'ylim', [0 -1*depthMax(1)]);
set(gca, 'xlim', [0 1500]);

text(nodesMean(end, 9), -1. * nodesMean(end, 5), ...
    [' ' num2str(-1. * nodesMean(end, 5), '%.0f')]);

text(nodesMax(end, 9), -1. * nodesMax(end, 5), ...
    [' ' num2str(-1. * nodesMax(end, 5), '%.0f')]);

for i=['nodesMean'; 'nodesMax ']'
   eval(['adcp = find(' i' '(:, 1) == 321);']);
   eval (['plot(' i' '(adcp,9),-1.*' i' '(adcp,5), ''bo'',''markerfacecolor'',''b'');']);
   eval (['text(' i' '(adcp,9),-1.*' i' '(adcp,5), num2str(-1.*' i' '(adcp,5),''%.0f''));']);
   eval(['rcms=find(' i' '(:,1)==308);']);
   eval (['plot(' i' '(rcms,9),-1.*' i' '(rcms,5), ''r<'',''markersize'',7)']);
end

set(gca, 'ydir', 'reverse');
xlabel('Horizontal Excursion (m)', 'fontsize', 12);
ylabel('Depth (m)', 'fontsize', 12);
set(gca, 'fontsize', 12, 'linewidth', 1);








